#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Sun Dec  3 22:57:52 2017

@author: Alain
"""

import jcamp as jc
import matplotlib.pyplot as plt


res = jc.JCAMP_reader("h1_2methylpropan1ol_78-83-1.jdx")

print (res)

delta = [res["x"][i]/res[".observe frequency"] for i in range(len(res["x"]))]
intensite = res["y"]

deltaIntegre=[]
integre=[]
I = 0
for i in range(len(delta)-2, 0, -1):
    deltaIntegre.append((delta[i]+delta[i+1])/2)
    I = I + (intensite[i]+intensite[i+1])*(delta[i+1]-delta[i])/2
    integre.append(I)
       
fig, ax1 = plt.subplots()
ax1.plot(delta, intensite, 'r')
ax1.set_xlabel('- déplacement chimique (ppm)')
ax1.get_yaxis().set_visible(False)
ax1.set_xlim(12,0)
#ax1.set_ylabel('Intensité', color='r')
#for tl in ax1.get_yticklabels():
#    tl.set_color('r')

ax2 = ax1.twinx()
ax2.plot(deltaIntegre, integre, 'b')
ax2.get_yaxis().set_visible(False)
ax2.set_xlim(12,0)
#ax2.set_ylabel('Intégration', color='b')
#for tl in ax2.get_yticklabels():
#    tl.set_color('b')
plt.show()
