// includes
#include <OneWire.h>// OneWire DS18S20, DS18B20, DS1822 Temperature Example
#include <Wire.h>
#include <DallasTemperature.h>
#include <Adafruit_ADS1015.h>

//variables
String identifier = "Test_2_0" ; // identificateur du programme nom_version
unsigned long tempsOrigine;// temps au démarrage de la carte
long defaultDelais = 1000 ; 
bool action = false ; // rien à faire ou données à renvoyer
bool autoRun = true ; // mode automatique : on renvoie des données en continue ; false: 1 seule fois
bool h0 = false ; // horloge = 0 à chaque nouvelle acquisition

//Sonde de températue Dallas DS18B20
const int ONE_WIRE_BUS =10 ; 
OneWire oneWire(ONE_WIRE_BUS);// Setup a oneWire instance to communicate with any OneWire devices (not just Maxim/Dallas temperature ICs)
DallasTemperature temperatures(&oneWire); // Pass our oneWire reference to Dallas Temperature. 
int defaultResolutionTemperature = 12 ; 
int resolutionTemperature = 12; 
unsigned long delayInMillis = 0 ; // délai minimal entre deux acquisition
unsigned long lastTempRequest = 0 ; // temps d'acquisition précédent

//CAN ADS1115
bool flagAdaFruit = true ;
Adafruit_ADS1115 ads;
float adsResolution = 0.1875 ;

byte flagU = 0 ; // B_0_0_A23_A01_A3_A2_A1_A0

void setup() 
{
  pinMode(13, OUTPUT);
  Serial.begin(9600);
  tempsOrigine = millis();
  temperatures.setResolution(defaultResolutionTemperature) ;// ou 9 ou 10 ou 11 IC Default 9 bit. If you have troubles consider upping it 12. Ups the delay giving the IC more time to process the temperature measurement
  temperatures.begin();
  ads.begin() ;
  reset() ; 
  temperatures.requestTemperatures(); // Send the command to get temperatures
  lastTempRequest = millis(); 
  info() ; 
}

void loop() 
{
  //S'il y a des octets à lire
   if(Serial.available()>0)
   {
    //Alors on le lit, normalement, il n'y en a qu'un: soit 'a' soit 'g'
    String message=Serial.readString();
    Serial.println(message) ; 
     switch(message[0])
     {
       case 'i' : // on demande l'identificateur du sketch
       info() ; 
          action = false ; 
          break ; 
       case 'g' : // on lance une (ou une série d'acquisition)
          if (autoRun)
          {
            action = true ; 
            if (h0)
            {
              tempsOrigine = millis();
              lastTempRequest = -10*delayInMillis ; 
            }
              
          }
          else
          {
            acquisition() ;
            action = false ; 
            }
            break ; 
       case 's' : // on s'arrête
           action = false ; 
           break ; 
       case 'm' : // gestion du mode automatique ou nou
         message.replace("m=", "") ;
         autoRun = message.toInt() == 1 ; 
       break ; 
       case 'h' : // remettre l'horloge à 0 ou pas
         message.replace("h=", "") ;
         h0 = message.toInt() == 1 ; 
       case 'R' :  // reset
         reset() ; 
         break ; 
       case 'D' :// délais
         message.replace("D=", "") ; 
         defaultDelais = message.toInt(); 
         regleDelais() ; 
       break ; 
       case 'U' : // gestion des tensions à acquérir
         message.replace("U=", "") ; 
         flagU = byte(message.toInt()) ; 
         break ; 
     case 'A' : // gain  adafruit
       message.replace("A=", "") ; 
       switch(message.toInt())
       {
  case 1 : set_ADAGain(GAIN_ONE) ; break ; 
   case 2 : set_ADAGain(GAIN_TWO) ; break ; 
   case 4 : set_ADAGain(GAIN_FOUR) ; break ; 
   case 8 : set_ADAGain(GAIN_EIGHT) ; break ; 
   case 16 : set_ADAGain(GAIN_SIXTEEN) ; break ; 
   default : set_ADAGain(GAIN_TWOTHIRDS) ; break ; // défaut
     }
     flagAdaFruit = true ;
     break ;
     }
  }

//****************************************************************************************************************
//**********************************************envoi ou non des données******************************************
//****************************************************************************************************************
 
 if(action)
 {
   if (millis()-lastTempRequest >= delayInMillis)// pour le capteur de température 9 à 12 bits
   {
   digitalWrite(13, HIGH);
   acquisition() ; 
 }
  digitalWrite(13, LOW);
  delay(1);
  }

}

void acquisition()
{
   unsigned long time =  millis() - tempsOrigine ;
   int n = temperatures.getDeviceCount() ;
   String res = "Time$"+String(time)+"$Temp$"+ String(n) ; 
   if (n  > 0)
   {
     for (int i = 0 ; i < n ; i++)
     {
        DeviceAddress adress ; 
        temperatures.getAddress(adress, i) ; 
         res += '$' ; 
         res +=  printAddress(adress) ;  
        float temp = temperatures.getTempC(adress) ;
       res += "$"+ String(temp);
        temperatures.setWaitForConversion(false);  // makes it async
        temperatures.requestTemperatures(); // Send the command to get temperatures
        temperatures.setWaitForConversion(true);  // makes it async
      }
       lastTempRequest = millis() ; 
   }
   unsigned long timeU ; 
   float u0 = readADAFruitSingle(0, &timeU) ; 
   res += "$A0$" ; 
   res += String(u0) ; 
   Serial.println(res) ;
}




float readADAFruitSingle(int channel, unsigned long* time)
{
int ArrayLength = 10    ;
int samplingInterval = 20 ;
int uArray[ArrayLength];   //Store the average value of the sensor feedback
int uArrayIndex=0;  
  unsigned long t1 = millis();
  int voltage= 0 ;
  while (uArrayIndex < ArrayLength)
  {
    uArray[uArrayIndex]=ads.readADC_SingleEnded(channel);
    delay(samplingInterval) ;
    uArrayIndex++ ;
  }
  unsigned long t2 = millis();
  unsigned long tmoy = (unsigned long)((t1+t2)/2) ;
  voltage = averagearray(uArray, ArrayLength)*adsResolution ; 
  *time = tmoy  ;
  return voltage ;
  
}
  
double averagearray(int* arr, int number){
  int i;
  int max,min;
  double avg;
  long amount=0;
  if(number<=0){
    Serial.println("Error number for the array to avraging!/n");
    return 0;
  }
  if(number<5){   //less than 5, calculated directly statistics
    for(i=0;i<number;i++){
      amount+=arr[i];
    }
    avg = amount/number;
    return avg;
  }else{
    if(arr[0]<arr[1]){
      min = arr[0];max=arr[1];
    }
    else{
      min=arr[1];max=arr[0];
    }
    for(i=2;i<number;i++){
      if(arr[i]<min){
        amount+=min;        //arr<min
        min=arr[i];
      }else {
        if(arr[i]>max){
          amount+=max;    //arr>max
          max=arr[i];
        }else{
          amount+=arr[i]; //min<=arr<=max
        }
      }//if
    }//for
    avg = (double)amount/(number-2);
  }//if
  return avg;
}

void regleDelais()
{
  if (resolutionTemperature == 0)
    delayInMillis = 0 ;
  else
    delayInMillis = 750 / (1 << (12 - resolutionTemperature)); 
  if (delayInMillis < defaultDelais)
    delayInMillis = defaultDelais ;
  }

void reset()
{
  defaultDelais = 1000 ; 
  autoRun = true ; // mode automatique : on renvoie des données en continue ; false: 1 seule fois
  h0 = false ; // horloge = 0 à chaque nouvelle acquisition
  resolutionTemperature = defaultResolutionTemperature ; // = 0 si on ne capte pas T
  defaultDelais = 1000 ; 
  regleDelais() ;
  set_ADAGain(GAIN_TWOTHIRDS) ;
}

void set_ADAGain(adsGain_t gain)
{
  ads.setGain(gain); 
 switch(gain)
{
 case GAIN_TWOTHIRDS : adsResolution =  0.1875 ; break ; 
  case GAIN_ONE : adsResolution =  0.125 ; break ; 
   case GAIN_TWO : adsResolution =  0.0625 ; break ; 
   case GAIN_FOUR : adsResolution =  0.03125 ; break ; 
   case GAIN_EIGHT : adsResolution =  0.015625 ; break ; 
   case GAIN_SIXTEEN : adsResolution =  0.0078125 ; break ; 
  }
  }
  
  void info()
  { 
    String info = "Info$" ; 
    info += identifier ; 
          if (autoRun)
            info += "$autoRun" ;
          else 
            info += "$oneRead" ; 
     info += temperatureInfo() ;    
          if (flagAdaFruit)
          {
            info += "Ada$" ; 
            info += String(adsResolution) ; 
          }
          Serial.println(info) ; 
 }
 
String temperatureInfo()
{
  int n = temperatures.getDeviceCount() ; 
  String tInfo = "$TInfo$" + String(n); 
  for (int i = 0 ; i < n ; i++)
  {
    tInfo += '$' ;  
    DeviceAddress adress ; 
    temperatures.getAddress(adress, i) ; 
    tInfo += (printAddress(adress)) ;
  } 
   return tInfo ; 
  }
  
  
// function to print a device address
String printAddress(DeviceAddress deviceAddress)
{
  String s ; 
  for (uint8_t i = 0; i < 8; i++)
  {
    // zero pad the address if necessary
    if (deviceAddress[i] < 16) 
      s += "0" ; 
    else
      s += String(deviceAddress[i], HEX) ;
  }
  return s ; 
}


