#include <SoftwareSerial.h>
#include <Adafruit_GFX.h>
#include <OneWire.h>
#include <DallasTemperature.h>

#define buttonPin 2
#define commandPin 3
#define softTX 4
#define softRX 5
#define redLEDPin 6  // le port de la led rouge
#define greenLEDPin 9  // le port de la led rouge
#define blueLEDPin 10 // le port de la led rouge
#define ONE_WIRE_BUS 7

#define analogPotar A0
#define analogRC A1

#define BAUD 115200 

Adafruit_SSD1306 lcd(4);
OneWire oneWire(ONE_WIRE_BUS);
DallasTemperature sensors(&oneWire);
SoftwareSerial BT(softRX, softTX) ;

void setup() 
{
  Serial.begin(BAUD) ;
  BT.begin(BAUD) ;
  pinMode(redLEDPin, OUTPUT);
  pinMode(greenLEDPin, OUTPUT);
  pinMode(blueLEDPin, OUTPUT);
  pinMode(buttonPin, INPUT) ; 
  sensors.begin();
  lcd.begin(SSD1306_SWITCHCAPVCC, 0x3C);  
  lcd.setTextSize(2);
  lcd.setTextColor(WHITE);
  lcd.clearDisplay() ;
  lcd.setCursor(0,0);
  lcd.display()  ;
  Serial.println("Test module ARDSSK") ; 
  Serial.println("Rouge") ; 
  testLED(HIGH,LOW,LOW) ; 
  Serial.println("Vert") ; 
  testLED(LOW,HIGH,LOW) ; 
  Serial.println("Bleu") ; 
  testLED(LOW,LOW,HIGH) ; 
  Serial.println("Blanc") ; 
  testLED(HIGH,HIGH,HIGH) ; 
  testLED(LOW,LOW,LOW) ;
  Serial.println("Test RC") ; 
  testRC() ; 
  Serial.println("GO... potentiomètre, température") ; 
}

void testLED(byte r, byte v, byte b)
{
  digitalWrite(redLEDPin, r);
  digitalWrite(greenLEDPin, v);
  digitalWrite(blueLEDPin, b);
  delay(1000) ;
}

void affiche(String msg)
{
  Serial.println(msg) ;
  BT.println(msg) ; 
}

void testRC()
{
  pinMode(commandPin, OUTPUT) ; 
  digitalWrite(commandPin, HIGH) ; 
  delay(2000) ; 
  int sensorValue = 1000 ;
  long start = millis() ; 
  digitalWrite(commandPin, LOW) ; 
  while (sensorValue > 10 && millis() < 15000)
  {
    sensorValue = analogRead(analogRC);
    affiche("DATA:TIME:"+String(millis()-start)+":A1:"+String(sensorValue)) ; 
  }
}

void loop() 
{
  int sensorValue = analogRead(analogPotar);
  int ddp = map(sensorValue, 0, 1023, 0, 5000) ;  
  affiche(String(ddp)) ; 
  sensors.requestTemperatures(); // Send the command to get temperatures
  lcd.clearDisplay();
  lcd.setCursor(0,0);
  lcd.print("mV = ") ;
  lcd.println(ddp) ; 
  lcd.print(sensors.getTempCByIndex(0)) ; 
  lcd.display() ; 
  int button = digitalRead(buttonPin) ; 
  digitalWrite(greenLEDPin, button) ;
  delay(100) ;
}
