// importation des bibliothèques

// variables utilisées par tous les programmes
int BAUD = 9600 ;
String info = "Programme modèle communication" ;
long delai = 1000 ; // en ms
boolean action = false ;

void setup()
{
  Serial.begin(BAUD) ;
  Serial.println(info) ;
}

void loop()
{
  if (Serial.available())
  {
    String message = Serial.readString() ;
    parse(message) ;
  }
  if (action)
  {
    job() ;
  }
}

/********* INTERPRETATION DES MESSAGES RECUS *************/

void parse(String msg)
{
  msg.replace("\r", "") ;
  msg.replace("\n", "") ;
  char ordre = msg[0];
  msg.replace(String(ordre), "") ;
  int valeur = 0 ;
  if (msg.length() > 0)
    valeur = msg.toInt() ;
  switch (ordre)
  {
    case 'I' :
      Serial.println(info) ;
      break ;
    case 'G' : // exécution d'une tâche régulièrement
      go() ;
      break ;
    case 'O' : // exécution d'une tâche unique
      job() ;
      break ;
    case 'S' : // on stoppe
      stop() ;
      break ;
    case 'D' : // réglage du délai
      delai = valeur ;
      break ;
    default :
      parse(ordre, valeur) ;
      break ;
  }
}

void parse(char ordre, long valeur) // traitements spécifiques au système
{
  switch (ordre)
  {
    case 'R' :
      break ;
  }
}

/********* GO - STOP *************/

void go()
{
  action = true ;
}

void stop()
{
  action = false ; 
}

/********* JOB *************/

void job()
{
  Serial.println("Je bosse !") ;
}
